module Handshake

open Data
open Formats
open Record

type SessionId = bytes * ConnectionEnd
type ServerName = str  
type CertName = str 

type Session = {
    sid: bytes;
    ms: bytes;
    server_cert: Certificate;
    ch: ClientHello;
    sh: ServerHello; 
    pms: bytes; }

val generateConnection: unit -> ConnectionId * ConnectionId 


#if fs
val connect: Net.conn -> ServerName -> ConnectionId * SessionId
val resume: Net.conn -> SessionId -> ConnectionId * SessionId
val accept: Net.conn -> CertName -> ConnectionId * SessionId
val close: ConnectionId -> bool -> unit
val rehandshake: ConnectionId -> SessionId -> ConnectionId * SessionId

val getSession: SessionId -> Session
val connect_ext: Net.conn -> ProtocolVersion -> ProtocolVersion -> CipherSuites -> str -> ConnectionId * SessionId
val resume_ext: Connection -> Session -> CipherSuites -> ProtocolVersion Option -> ConnectionId * SessionId
val set_debug: bool -> unit
#endif
