module Handshake

open Data
open Crypto
open Formats_ciphersuites
open Formats
open Conversions_lowlevel
open Record



type SessionId = bytes * ConnectionEnd
type Session = {
  sid: bytes;
  ms: bytes;
  server_cert: Certificate;
  ch: ClientHello;
  sh: ServerHello; 
  pms: bytes;
}



type event = 
  | GenConn of ConnectionId * ConnectionId

let tr = Pi.trace()


let fake_conn () = 
#if fs
    Net.fake ()
#else
  "conn"
#endif



let generateConnState () = 
  let ek = noncetobytes(mkNonce ()) in
  let iv = noncetobytes(mkNonce ()) in
  let mk = noncetobytes(mkNonce ()) in
  { 
    cipher_state = BlockCipherState (ek,iv); 
    mk = mk; 
    seq_num = 0;
    sparams = {        
      bulk_cipher_algorithm = BCA_aes;
      cipher_type = CT_block;
      mac_algorithm = MA_sha1;
      }
  }

let generateConnection () = 
  let conn1 = generateConnState () in
  let conn2 = generateConnState () in
  let cconn = 
  { net_conn = fake_conn ();
    entity = Client;
    sessid = empty_bstr;
    crt_version = ver2PV TLS1p0;
    read = conn1;
    write = conn2;
#if concrete
    buffer = empty_bstr;
#endif
  } 
  in
  let sconn = 
  { net_conn = fake_conn ();
    entity = Server;
    sessid = empty_bstr;
    crt_version = ver2PV TLS1p0;
    read = conn2;
    write = conn1;
#if concrete
    buffer = empty_bstr;
#endif
  } 
  in
  let cid = noncetobytes(mkNonce()) in
  let sid = noncetobytes(mkNonce()) in
  let cconnid = (cid,Client) in
  let sconnid = (cid,Server) in
  storeConnection cconnid cconn;
  storeConnection sconnid sconn;
  Pi.log tr (GenConn (cconnid,sconnid));
  cconnid,sconnid
  



type ServerName = str  
type CertName = str 


let connect (x: Net.conn) (y: ServerName) : ConnectionId * SessionId  = 
  failwith "use the files 'myhandshake.ml[i]'"

let rehandshake (x: ConnectionId) (y: SessionId) : ConnectionId * SessionId =
  failwith "use the files 'myhandshake.ml[i]'"

let resume (x: Net.conn) (y: SessionId) : ConnectionId * SessionId =
  failwith "use the files 'myhandshake.ml[i]'"

let accept (x: Net.conn) (y: CertName) : ConnectionId * SessionId =
  failwith "use the files 'myhandshake.ml[i]'"

let close (x: ConnectionId) (y: bool) : unit = 
  failwith "use the files 'myhandshake.ml[i]'"

let connect_ext (x: Net.conn) (y: ProtocolVersion) (z: ProtocolVersion) (u: CipherSuites) (v: str) : ConnectionId * SessionId = 
  failwith "use the files 'myhandshake.ml[i]'"

let resume_ext (x: Connection) (y: Session) (z: CipherSuites) (u: ProtocolVersion option) : ConnectionId * SessionId = 
  failwith "use the files 'myhandshake.ml[i]'"

let getSession (x: SessionId) : Session = 
  failwith "use the files 'myhandshake.ml[i]'"

let set_debug (x: bool) : unit = 
  failwith "use the files 'myhandshake.ml[i]'"
