open Data
open Crypto
open Formats_ciphersuites
open Formats

(* databases: private channels
   or cells: public channels *)
#if fs
#else
//val connDb: Pi.chan
#endif


type CipherState = 
  | BlockCipherState of bytes * bytes
  | StreamCipherState of stream_cipher_state

(*--- recConnStBegin *)
type ConnectionState = {
  cipher_state: CipherState;
  mk: bytes;
  seq_num: int; 
  sparams: SecurityParameters; }
(*--- recConnStEnd *)

type ConnectionId = bytes * ConnectionEnd

#if concrete
type Connection = {
  net_conn: Net.conn;
  entity: ConnectionEnd;
  sessid: SessionID;
  crt_version: ProtocolVersion;
  read: ConnectionState;
  write: ConnectionState; 
  buffer: bytes;
}
#else
(*--- recConnBegin *)
type Connection = {
  net_conn: Net.conn;
  entity: ConnectionEnd;
  sessid: bytes;
  crt_version: ProtocolVersion;
  read: ConnectionState;
  write: ConnectionState; }
(*--- recConnEnd *)
#endif



#if fs
(*--- recInterfaceBegin *)
val send: ConnectionId -> bytes -> unit
val recv: ConnectionId -> bytes
(*--- recInterfaceEnd *)
#endif



#if cv
(*** computational analysis ***)

#if thm_record_auth_comp 
val send: ConnectionId -> bytes -> unit
val recv: ConnectionId -> bytes
val msgen: ConnectionId -> unit
val leak_msgen : ConnectionId -> bytes
#else
val msgen: ConnectionId -> unit
val send_fresh_payload: bytes * ConnectionEnd -> unit
#endif

#else
(*** symbolic analysis ***)

#if record
val send: ConnectionId -> bytes -> unit
val recv: ConnectionId -> bytes
#endif
val seqnumChan: bytes Pi.chan

(* for testing syntactic secrecy of a fresh payload *)
#if recordsecr
val send_fresh_payload: bytes * ConnectionEnd -> unit
val chksecrecyChan: bytes Pi.chan
#endif

(* for leaking connection keys *)
#if leakConn
val leakConnection: ConnectionId -> Connection
#endif

#endif








#if fs
(* used by the handshake, not given to the adversary *)
val init_sp: CipherSuite -> SecurityParameters
val updateConnState_keys: ConnectionState -> CipherState -> bytes -> ConnectionState 
val initConn: Net.conn -> ConnectionEnd -> ProtocolVersion -> Connection
val updateReadConnectionState: Connection -> ConnectionState -> Connection
val updateWriteConnectionState: Connection -> ConnectionState -> Connection
val updateConn_version: Connection -> SessionID -> ProtocolVersion -> Connection

val storeConnection: ConnectionId -> Connection -> unit
val getConnection: ConnectionId -> Connection

val send_hs: Connection -> bytes -> Connection
val recv_hs: Connection -> bool -> Connection * bytes
val send_ccs: Connection -> bytes -> Connection
val recv_ccs: Connection -> Connection * bytes
val send_alert: Connection -> bytes -> Connection
val recv_alert: Connection -> Connection * bytes
val send_null: Net.conn -> ProtocolVersion -> ContentType -> bytes -> unit
val recv_null: Net.conn -> ContentType -> bytes
#endif
 



#if fs
(* for debugging *)
val sout : out_channel
val rout : out_channel
val set_debug: bool -> unit
#endif


