(* Copyright (c) Microsoft Corporation.  All rights reserved.  *)
(********************************************************)
(* The Database of Principals *)
(*********************************************************
   Defines:
     type principal: Principals
 *********************************************************)

open Pi
open Data
open Db
//open Cell
open Crypto

type principalX = 
       {subject:str;
	cert: bytes;
	pubkey: key;
	privkey: key;}

let principalX (subject:str) (cert:bytes) (pubkey:key) (privkey:key) = 
{subject=subject;cert=cert;pubkey=pubkey;privkey=privkey}
let subject px = px.subject
let cert px = px.cert
let pubkey px = px.pubkey
let privkey px = px.privkey

let x509db = create ()

let issuer = str "Root"

let genX509 (subj:str) = 
  let skey = rsa_keygen() in  
  let pkey = rsa_pub(skey) in
  let cert = x509signcert issuer subj (keytobytes pkey) in
  let prin = (principalX subj cert pkey skey) in
    insert x509db subj prin
 

let getX509 (u:str) = select x509db u 

let getX509Cert (u:str) = 
  let p = getX509 u in
    p.cert

let getPublicKey (u:str) = 
  let p = getX509 u in
    p.pubkey

let getPrivateKey (u:str) = 
  let p = getX509 u in
    p.privkey


type leakEv = Leak of str

let leakEv = Pi.trace()

let leakX509 (u:str) = 
  let prin = select x509db u in
    Pi.log leakEv (Leak(u));
    prin




