(* Copyright (c) Microsoft Corporation.  All rights reserved.  *)

open Data



#if fs

type listener = L of string
type conn = C of bytes Pi.chan * bytes Pi.chan
let httpChan = Db.create()

let fake () = 
  let q = Pi.chan "req" in
  let r = Pi.chan "resp" in
    C (q,r)

let connect u = 
  Printf.printf  "Connecting to %s\n" u;
  let q = Pi.chan "req" in
  let r = Pi.chan "resp" in
  Db.insert httpChan u (q,r);
  C (q,r)

let rec wait u = 
  try (
  let (q,r) = Db.select httpChan u in
    C (r,q)
  ) with _ -> wait u

let listen u = 
  Printf.printf  "Listening at %s\n" u;
  L u

let accept (L u) = 
  Printf.printf  "Accepting...\n";
  wait u

let close (C(q,r)) = ()
  
let send (C(q,r)) m = 
  Printf.printf  "  Sending: %a\n" fpbytes m;
  Printf.printf  "  containing %i symbols\n" (syms_bytes m);
  Pi.send q m

let recv (C(q,r)) = 
  Pi.recv r

let sendl c p = send c p

let recvl c = recv c


#else

type conn = string  
type listener = string  

let connect u = "http"
let listen u = "http"
let accept (a) = a 
let close c = ()


let httpChan = Pi.chan "http"
let send c p = 
  Pi.send httpChan p

let recv c = 
  Pi.recv httpChan

let sendl c p = 
  Pi.send httpChan p

let recvl c = 
  Pi.recv httpChan

#endif

let get_host (u:string) = u


