(* Copyright (c) Microsoft Corporation.  All rights reserved.  *)
(* table lookups, modelled as abstract channels *)
open Pi

#if fs 
type ('k,'v) t = Db of ('k * 'v) list ref

let create () = Db (ref [])
let select (Db c) k = List.assoc k !c
let insert (Db c) k v = c := (k,v)::!c ; ()
  
#else
type ('k,'v) t = ('k *'v) chan
let create () = chan "database"
let select db k = let (k',v) = Pi.recv db in if k'=k then v else failwith "entry not found"
let insert db k v = Pi.send db (k,v) // badly relying on PV:should use a replication 

#endif

#if cv
(* added for compromise *)
open Data
open Crypto
type guid = bytes
type ('a)db = (bytes * 'a option) list ref

let newdb (x:guid) : ('a)db = (ref [])
let selectdb (c:('a)db) k = try List.assoc k !c with Not_found -> failwith "[select] failed"
let insertdb (c:('a)db) k v = c := (k,Some v)::!c ; ()
#endif
