
type ('a,'b) cell = Pack of 'a * 'b

let mkCell s x = Pack(s,x)

let readCell s (Pack(ss,x)) =
  if s = ss then x
  else failwith "incorrect tag"

#if fs

type ('k,'v) t = Db of ('k * 'v) list ref

let create () = Db (ref [])
let select (Db c) k = List.assoc k !c
let insert (Db c) k v = c := (k,v)::!c ; ()


#else


type ('k,'v) t = ('k *'v) chan

let create () = 
  chan "public database"

let select db k = 
  let cell = Pi.recv db in
  readCell k cell

let insert db k v = 
  Pi.send db (k, mkCell k v)

#endif

