(* Copyright (c) Microsoft Corporation.  All rights reserved.  *)
open Data 
open Crypto

type principalX =
       {subject:str;
	cert: bytes;
	pubkey: key;
	privkey: key;}

val cert: principalX -> bytes
val subject: principalX -> str
val pubkey: principalX -> key
val privkey: principalX -> key


#if fs
#else
//val x509db: 'a Pi.chan
#endif




//#if leak
//val leakUserPassword: str -> principalU
val leakX509: str -> principalX
//#endif


#if fs
val getX509: str -> principalX
val getPublicKey: str -> key
val getPrivateKey: str -> key
#endif
val getX509Cert: str -> bytes 


// enables the adversary to generate keys
val genX509: str -> unit


#if paper
(* Functions used in TLS *)
(*--- prinsBegin *)
module Prins
  type CertName = str                                // Certificate subject name
  val checkX509Cert: bytes -> (CertName * pubkey)     // Check certificate validity
  val genX509Cert: CertName -> unit                   // Generate fresh certificate
  val getX509Cert: CertName -> bytes                  // Get certificate from store
  val getPrivateKey: CertName -> privkey              // Get certificate private key
  val leakX509: CertName -> privkey                   // Leak private key to attacker
(*--- prinsEnd *)
#endif
