(* Copyright (c) Microsoft Corporation.  All rights reserved.  *)

val fork: (unit -> unit) -> unit
val yieldf: int -> unit (* for gentle thread scheduling in examples *)

type name
val name: string -> name  (* string used only for pretty-printing *)
val secret: 'a -> unit    

type 'a chan
val chan: string -> 'a chan
val send: 'a chan -> 'a -> unit
val recv: 'a chan -> 'a

#if fs
val fpname: out_channel -> name -> unit
val spname: unit -> name -> string
#endif

type 'a trace
val trace: unit -> 'a trace
val log: 'a trace -> 'a  -> unit
val query: 'a trace -> ('a -> 'a)  -> bool

