(* Copyright (c) Microsoft Corporation.  All rights reserved.  *)
open Data


type conn
val send: conn -> bytes -> unit
val recv: conn -> bytes
val sendl: conn -> bytes -> unit
val recvl: conn -> bytes

#if fs
type listener
val fake: unit -> conn
val connect: string -> conn
val listen: string -> listener
val accept: listener -> conn
val close: conn -> unit

#else
val httpChan: (str * bytes Pi.chan * bytes Pi.chan) Pi.chan
val recvl: conn -> bytes
val sendl: conn -> bytes -> unit
#endif


val get_host : string -> string
#if concrete
val get_abspath : string -> string
#endif


#if paper
(*--- netBegin *)
module Net
  type conn                       // A TCP Socket     
  val connect: string -> conn      // Connect to a URI 
  val listen: string -> conn       // Listen at a URI  
  val close: conn -> unit          // Close connection 
  val send: conn -> bytes -> unit   // Send message     
  val recv: conn -> bytes          // Receive message  
(*--- netEnd *)
#endif
