(* Copyright (c) Microsoft Corporation.  All rights reserved.  *)
type ('k,'v) t

val create: unit -> ('k,'v) t
val select: ('k,'v) t -> 'k -> 'v
val insert: ('k,'v) t -> 'k -> 'v -> unit

#if cv
open Crypto
open Data

type ('a)db = (bytes * 'a option) list ref

val newdb: guid -> ('a)db
val insertdb: ('a)db -> bytes -> 'a -> unit
val selectdb: ('a)db -> bytes -> 'a option
#endif
