open Data
open Formats_ciphersuites
open Formats


(* constants *)

val empty_bstr : bytes
val empty_sid : bytes
val ccs_msg : bytes

(* SSLv3 constants *)
 
val ssl_pad1_md5: bytes
val ssl_pad2_md5: bytes
val ssl_pad1_sha1: bytes
val ssl_pad2_sha1: bytes

val ssl_sender_client: bytes
val ssl_sender_server: bytes


(* conversions *)

val zeros: int -> bytes
val bytes_of_seq: int -> bytes

val bytes_of_version: version -> bytes
val version_of_bytes: bytes -> version

val ver2PV: version -> ProtocolVersion 
val PV2ver: ProtocolVersion -> version 
val PV2pmver: ProtocolVersion -> pm_version

val bytes_of_ContentType: ContentType -> bytes
val ContentType_of_bytes: bytes -> ContentType

val Alert_of_bytes: bytes -> Alert
val bytes_of_AlertDescription: AlertDescription -> bytes
val string_of_Alert: Alert -> string

val bytes_of_HandshakeType: HandshakeType -> bytes
val HandshakeType_of_bytes: bytes -> HandshakeType

val CipherSuite_of_bytes : bytes -> CipherSuite
val bytes_of_CipherSuite : CipherSuite -> bytes
val bytes_of_CipherSuites: CipherSuites -> bytes
val CipherSuites_of_bytes: bytes -> CipherSuites

val bytes_of_CompressionMethod: CompressionMethod -> bytes
val CompressionMethod_of_bytes: bytes -> CompressionMethod
val bytes_of_CompressionMethods: CompressionMethods -> bytes
val CompressionMethods_of_bytes: bytes -> CompressionMethods


(* parsing functions *)
val parseClientHello: bytes -> (bytes * bytes * bytes * bytes * bytes * bytes)
val parseServerHello: bytes -> (bytes * bytes * bytes * bytes * bytes)
val parsePMS: bytes -> (bytes * bytes)
val parseHandshake: bytes -> (bytes * bytes * bytes)
val parseRecord: bytes -> (bytes * bytes * bytes * bytes)

val get_last_block: int -> bytes -> bytes


(* other fuinctions *)
val selectVersion: ProtocolVersion -> ProtocolVersion -> ProtocolVersion -> ProtocolVersion
val selectCipherSuite: CipherSuites -> CipherSuites -> bCipherSuite
val selectCompressionMethod: CompressionMethods -> CompressionMethod
val lt_ver: ProtocolVersion -> ProtocolVersion -> bool

