(* an implementation of write-once reference cells *)

type ('a,'b) cell

#if fs
val mkCell: 'a -> 'b -> ('a,'b) cell
val readCell: 'a -> ('a,'b) cell -> 'b


type ('k,'v) t

val create : unit -> ('k,'v) t
val select: ('k,'v) t -> 'k -> 'v
val insert: ('k,'v) t -> 'k -> 'v -> unit
#endif


