(* Copyright (c) Microsoft Corporation.  All rights reserved.  *)
// table lookups, modelled as abstract channels

#light "off"

type ('k,'v) t = Db of ('k * 'v) list ref

let create () = Db (ref [])
let select (Db c) k = try List.assoc k !c with Not_found -> failwith "[select] failed"
let insert (Db c) k v = c := (k,v)::!c ; ()
  
