open Data
open Formats_ciphersuites
open Formats
open Record

(* 
 databases: private channels -> keep the db channels private (i.e. comment the next lines)
 or cells: public channels -> make the channels public (i.e. uncomment the next lines)
*)
#if fs
#else
//val hmDb: Pi.chan
//val finDb: Pi.chan
//val finResDb: Pi.chan
#endif

#if fs
#else
//val sessionsDb: Pi.chan
#endif


(*** sessions ***)

type SessionId = bytes * ConnectionEnd

(*--- sessionBegin *)
type Session = {
    sid: bytes;
    ms: bytes;
    server_cert: Certificate;
(*--- sessionEnd *)
(*--- session2Begin *)

    ch: ClientHello;
    sh: ServerHello; 
    pms: bytes; }
(*--- session2End *)

type ServerName = str  // symbolically, the subject of the server's certificate
type CertName = str    // the "certificate name" (that is, the subject of the certificate)



(*** the usual interface ***)
#if fs
(*--- hsInterfaceBegin *)
val connect: Net.conn -> ServerName -> ConnectionId * SessionId
val resume: Net.conn -> SessionId -> ConnectionId * SessionId
val accept: Net.conn -> CertName -> ConnectionId * SessionId
val close: ConnectionId -> bool -> unit
(*--- hsInterfaceEnd *)
val rehandshake: ConnectionId -> SessionId -> ConnectionId * SessionId
#endif



(*** verification ***)

#if cv 
(* for CryptoVerif only *)
#if thm_handshake_auth_comp
val wrapper_sendFinished :  bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes
val wrapper_recvFinished :  bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes
#else
val clientKeyExchange_phase: bytes -> bytes -> bytes -> str -> bytes -> bytes -> bytes
val wrapperFinished :  bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes -> bytes
#endif

#else
(* for ProVerif only *)

(* full handshake attacker interface *)
val clientHelloMsgs_att: Net.conn -> ProtocolVersion -> SessionID -> CipherSuites -> Random
val clientKeyExchange_phase_att: Random -> ServerName -> unit
val cSendFinished_att: Random -> unit
val cRecvFinished_att: Random -> ConnectionId * SessionId

val serverHelloMsgs_att: Net.conn -> ProtocolVersion -> ProtocolVersion -> CipherSuites -> Random 
val serverKeyExchange_phase_att: Random -> CertName -> unit
val sRecvFinished_att: Random -> unit
val sSendFinished_att: Random -> ConnectionId * SessionId

(* resumption attacker interface: uncomment 'if fs' if it is _not_ given to the attacker *)
#if res
val clientHelloMsgsRes_att: Net.conn -> SessionId -> ProtocolVersion -> Random 
val cRecvFinishedRes_att: Random -> unit 
val cSendFinishedRes_att: Random -> ConnectionId * SessionId

val serverHelloMsgsRes_att: Net.conn -> ProtocolVersion -> ProtocolVersion -> CipherSuites -> Random
val sSendFinishedRes_att: Random -> unit 
val sRecvFinishedRes_att: Random -> ConnectionId * SessionId
#endif

(* for checking secrecy *)
#if hssecr
val chksecrecyChan : bytes Pi.chan
#endif

#if passwd
val cRecvFinishedPwd_att: Random -> ConnectionId * SessionId
val sSendFinishedPwd_att: Random -> ConnectionId * SessionId
#endif
#if fs
val pwdAppDb: ((string * ConnectionId), (Connection *str)) Db.t
#endif

#endif (* if cv *)



#if concrete
(* for testing only *)
val getcSession: SessionId -> Session
val getsSession: SessionId -> Session
val connect_ext: Net.conn -> ProtocolVersion -> ProtocolVersion -> CipherSuites -> ServerName -> ConnectionId * SessionId
val accept_ext: Net.conn -> CertName -> ProtocolVersion -> ProtocolVersion -> CipherSuites -> ConnectionId * SessionId
val resume_ext: Connection -> Session -> CipherSuites -> ProtocolVersion Option -> ConnectionId * SessionId
val set_debug: bool -> unit
#endif


#if fs
val generateConnection: unit -> ConnectionId * ConnectionId 
#endif



