module Conversions

open Data
open Formats
open Conversions_lowlevel


val bytes_of_ProtocolVersion: ProtocolVersion -> bytes
val ProtocolVersion_of_bytes: bytes -> ProtocolVersion

val ClientHello_of_bytes: bytes -> ClientHello
val ServerHello_of_bytes: bytes -> ServerHello
val Certificate_of_bytes: bytes -> Certificate
val ServerHelloDone_of_bytes: bytes -> ServerHelloDone
val ClientKeyExchange_of_bytes: bytes -> ClientKeyExchange
val Finished_of_bytes: bytes -> Finished

val bytes_of_Handshake: Handshake -> bytes



#if concrete
val string_of_ProtocolVersion: ProtocolVersion -> string 
val string_of_bCipherSuite: bCipherSuite -> string
#endif
val printClientHello: string -> ClientHello -> unit
val printServerHello: string -> ServerHello -> unit
val printHandshake: bytes -> unit
val print_tls: ContentType -> ProtocolVersion -> int -> unit
