module App_passwd

open Pi
open Data
open Formats
open Record
open Handshake


type UserName = str
type ServerName = str
type CertName = str

type event = 
  | SendPasswd of ConnectionEnd * bytes * UserName * ServerName
  | AcceptPasswd of ConnectionEnd * bytes * UserName * ServerName

let tr = Pi.trace()



let pwdDb = Db.create()


let generatePasswd client server = 
  let pwd = Crypto.mkNonce() in
  Db.insert pwdDb (client,server) pwd

let insertPasswd client server pwd = 
  Db.insert pwdDb (client,server) pwd

let get_pwd client server = 
  Db.select pwdDb (client,server)

let get_password (client:str) (server:str) = 
#if fs
  Printf.printf "\nPlease introduce your password\n";
  utf8 (str (read_line ()))
#else
  get_pwd client server
#endif



#if concrete
let sendPasswd connid (client:str) server = 
  let conn = getConnection connid in
  let pwd = get_password client server in
  Printf.printf "\n[client_app] sending password\n";
  Pi.log tr (SendPasswd(conn.entity,pwd,client,server));
  let cmsg = concatvar (utf8 (str client)) pwd in
  send connid cmsg;
  let secret = recv connid in
  Printf.printf "\n[client_app] Received server secret\n";      
  close connid false
#else

#if fs
(*--- clientPasswdBegin *)
let sendPasswd connid client server = 
  let pwd = get_password client server in
  log tr (SendPasswd(Client, pwd, client, server));
  let msg = concatvar (utf8 client) pwd in
  Record.send connid msg
(*--- clientPasswdEnd *)

#else

let sendPasswd connid client server = 
  let conn, subj = Db.select pwdAppDb ("cPwdApp",connid) in
  if subj = server then 
    begin
      let pwd = get_password client server in
      log tr (SendPasswd(conn.entity, pwd, client, server));
      let cmsg = concatvar (utf8 client) pwd in
      Record.send connid cmsg
    end
  else
    failwith "wrong entity"

let sendFakePasswd connid client server pwd = 
  let conn, subj = Db.select pwdAppDb ("cPwdApp",connid) in
  if subj = server then 
    begin
      log tr (SendPasswd(conn.entity, pwd, client, server));
      let cmsg = concatvar (utf8 client) pwd in
      Record.send connid cmsg
    end
  else
    failwith "wrong entity"

#endif
#endif


#if fs
(* client handshake + application *)

let tlsconnect uri = 
  let uri = istr uri in
  let netconn = Net.connect uri in 
  let shost = Net.get_host uri in 
  connect netconn (str shost)

(*--- clientPasswdAppBegin *)
let clientPasswd uri = 
  let connid, sessionid = tlsconnect uri in
  Printf.printf "\nType your user name\n";
  let client = read_line() in
  sendPasswd connid (str client) uri
(*--- clientPasswdAppEnd *)

#endif


#if concrete
let recvPasswd connid server = 
  let conn = getConnection connid in
  let cmsg = recv connid in
  let clientb, cpwd = iconcat cmsg in
  let client = iutf8 clientb in
  if cpwd = get_pwd client server then
    begin
      Printf.printf "\n[server_app] client password matches\n";
      Pi.log tr (AcceptPasswd(conn.entity, cpwd, client, server));
      printf "\n[server_app] sending secret\n";
      let secret = Crypto.mkNonce256() in
      let stls = send connid (Crypto.noncetobytes secret) in	  
      close connid false
    end
  else 
    begin
      Printf.printf "\n[server_app] password does not match\n";
      close connid false
    end

#else

#if fs
(*--- serverPasswdBegin *)
let recvPasswd connid server = 
  let conn = getConnection connid in
  let cmsg = Record.recv connid in
  let client', cpwd = iconcat cmsg in
  let client = iutf8 client' in
  if cpwd = get_pwd client server then
    log tr (AcceptPasswd(conn.entity, cpwd, client, server))
  else 
    failwith "wrong password"
(*--- serverPasswdEnd *)
#else

let recvPasswd connid server = 
  let conn, subj = Db.select pwdAppDb ("sPwdApp",connid) in
  if subj = server then 
    let cmsg = Record.recv connid in
    let client', cpwd = iconcat cmsg in
    let client = iutf8 client' in
    if cpwd = get_pwd client server then
      log tr (AcceptPasswd(conn.entity, cpwd, client, server))
    else 
      failwith "wrong password"
  else
    failwith "wrong entity"

#endif
#endif  


#if fs
(* server handshake + application *)
let serverPasswd (uri:str) (certname:str) () = 
  let sock = Net.listen (istr uri) in
  let netconn = Net.accept sock in
  let connid, sessid = accept netconn certname in
  recvPasswd connid certname;
  Net.close netconn;
  Printf.printf "\n[server_app] I'm done\n"
#endif
