/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Out;

public final class Action {
    String content;
    int priority;
    private boolean isLookAction;

    public Action(String content, int priority) {
        this.content = content.trim();
        this.priority = priority;
    }

    public Action getHigherPriority(Action other) {
        if (other == null) {
            return this;
        }
        if (other.priority > this.priority) {
            return this;
        }
        return other;
    }

    public String toString() {
        return "Action (priority " + this.priority + ", lookahead " + this.isLookAction + ") :" + Out.NL + this.content;
    }

    public boolean isEquiv(Action a) {
        return this == a || this.content.equals(a.content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Action) {
            return this.isEquiv((Action)o);
        }
        return false;
    }

    public boolean isLookAction() {
        return this.isLookAction;
    }

    public void setLookAction(boolean b) {
        this.isLookAction = b;
    }
}

