/* --------------------------Usercode Section------------------------ */
   
import java_cup.runtime.*;
      
%%
   
/* -----------------Optionen und Deklarationen ----------------- */

%eofval{
  return new Symbol(sym.EOF);
%eofval}
   
/* only for debugging */
/*%debug*/
%full

/* Die generierte Datei soll ClauseLexer heien */
%class ReLexer

%line
%column
    
/* CUP-Kompatibilittsmodus einschalten */
%cup
   

%{   
    private Symbol symbol(int type) 
    {
        return new Symbol(type, yyline, yycolumn);
    }
    
    private Symbol symbol(int type, Object value) 
    {
        return new Symbol(type, yyline, yycolumn, value);
    }

%}
   

LineTerminator = \r|\n|\r\n
WhiteSpace     = {LineTerminator} | [ \t\f]
AlphaNum       = [A-Za-z0-9]
%%

/* ------------------------Lexikalische Regeln---------------------- */

{AlphaNum}   {return symbol(sym.SYMBOL,yytext());}   

"|"          { return symbol(sym.ODER);}

"("          {return symbol(sym.LPAR);}
")"          {return symbol(sym.RPAR);}

{WhiteSpace}       { /* WhiteSpace, also nichts zu tun */ }



