import java.util.*;
public class IfElseStatement extends Statement{

    public Statement s1;
    public Statement s2;
    public Condition c;
    boolean isReachable = false;

    public IfElseStatement(Condition c, Statement s1, Statement s2){
	this.s1 = s1;
	this.s2 = s2;
	this.c = c;
    }

    public Domain  _propagate (){
	try{
	    isReachable = c.eval(symTab);
	}catch(NullPointerException e){
	    Domain d_s1, d_s2;
	    d_s1 = s1.propagate(symTab);
	    d_s2 = s2.propagate(symTab);
	    return d_s1.join(d_s2);
	}
	
	if(isReachable)
	    return s1.propagate(symTab);
	else
	    return s2.propagate(symTab);
    }

    public boolean isEmpty(){
	return false;
    }
    public String _toString(){
	return "if("+c+"){\n"+s1.toString()+"} else { \n"+s2.toString()+"}\n";
    }
}
