import java.util.*;

public class Domain{

    public HashMap<String,Integer> hashtab = null; 
    
    public Domain(){}
    
private Domain(HashMap<String,Integer> hashtab){
	this.hashtab = hashtab;
    }
    
    public Domain(Domain d){
	if (d.hashtab != null)
	    hashtab = (HashMap<String, Integer>)d.hashtab.clone();
    }
    public void put(String s, Integer i){
	if(hashtab == null)
	    hashtab = new HashMap<String,Integer>();
	hashtab.put(s,i);
    }

    public boolean containsKey(String s){
	if(hashtab == null) return false;
	return hashtab.containsKey(s);
    }
    
    public Integer get(String s){
	return hashtab.get(s);
    }

    public String toString(){
	if(hashtab == null) return "bottom";
	StringBuffer sb = new StringBuffer();
	for(String s: hashtab.keySet())
	    sb.append(s+" -> "+hashtab.get(s)+";");
	    
	sb.append("\n");
	return sb.toString();

    }

    public boolean equals(Domain d){
	if((d.hashtab == hashtab) &&(hashtab == null)) return true;
	if (d.hashtab == null || hashtab == null) return false;
	for(String s: d.hashtab.keySet()){
	    Integer i1 = hashtab.get(s);
	    Integer i2 = d.hashtab.get(s);
	    if(i1 == null && i2 != null) return false;
	    if(i1 != null && i2 == null) return false;
	    if(i1 == null && i2 == null) continue;
	    if(! i1.equals(i2))return false;
	}
	for(String s: hashtab.keySet()){
	    Integer i1 = hashtab.get(s);
	    Integer i2 = d.hashtab.get(s);
	    if(i1 == null && i2 != null) return false;
	    if(i1 != null && i2 == null) return false;
	    if(i1 == null && i2 == null) continue;
	    if(! i1.equals(i2)) return false;
	}
	return true;
    }

    public Domain join(Domain d){
	assert(d!=null): "join: Domain is null";
	HashMap<String,Integer> res  = new  HashMap<String, Integer>();
	if(hashtab == null && d.hashtab == null)
	    return new Domain();
	if(hashtab == null) 
	    return new Domain((HashMap<String, Integer>)d.hashtab.clone());
	if (d.hashtab == null) 
	    return new Domain((HashMap<String, Integer>)hashtab.clone());
	
	for(String s: d.hashtab.keySet()){
	    if (this.hashtab.get(s) == null || d.hashtab.get(s) == null) res.put(s,null);
	    else if (this.hashtab.get(s).equals(d.hashtab.get(s))) res.put(s, hashtab.get(s));
	    else res.put(s, null);
	}
	return new Domain(res);
    }


}
