import java_cup.runtime.*;

%%

%line
%column
%cup
%class Scanner


%%

typedef  		{return new Symbol(sym.TYPEDEF, yyline, yycolumn);}
alias  			{return new Symbol(sym.ALIAS, 	yyline, yycolumn);}
if  			{return new Symbol(sym.IF, 	yyline, yycolumn);}
while  			{return new Symbol(sym.WHILE, 	yyline, yycolumn);}
else 			{return new Symbol(sym.ELSE, 	yyline, yycolumn);}
write			{return new Symbol(sym.WRITE, 	yyline, yycolumn);}
read			{return new Symbol(sym.READ, 	yyline, yycolumn);}

int 			{return new Symbol(sym.INT, 	yyline, yycolumn);}
bool 			{return new Symbol(sym.BOOL, 	yyline, yycolumn);}

true			{return new Symbol(sym.TRUE, 	yyline, yycolumn);}
false			{return new Symbol(sym.FALSE, 	yyline, yycolumn);}

[A-z_$][0-9A-z_$]* 	{return new Symbol(sym.IDENTIFIER,	yyline, yycolumn, yytext());}
-?[0-9]+  		{return new Symbol(sym.NUMBER, 	yyline, yycolumn, new Integer(yytext()));}

\(			{return new Symbol(sym.LPAR,	yyline, yycolumn);}
\)			{return new Symbol(sym.RPAR,    yyline, yycolumn);}

\{      		{return new Symbol(sym.LBR,     yyline, yycolumn);}
\}      		{return new Symbol(sym.RBR,     yyline, yycolumn);}

\+      		{return new Symbol(sym.PLUS, 	yyline, yycolumn);}
\-      		{return new Symbol(sym.MINUS, 	yyline, yycolumn);}

;       		{return new Symbol(sym.SEMIC, 	yyline, yycolumn);}
,			{return new Symbol(sym.COMMA, 	yyline, yycolumn);}
=       		{return new Symbol(sym.ASSIGN, 	yyline, yycolumn);}
\!			{return new Symbol(sym.NOT, 	yyline, yycolumn);}
== 			{return new Symbol(sym.EQUAL,	yyline, yycolumn);}
\<=			{return new Symbol(sym.LESSEQ, 	yyline, yycolumn);}
&& 			{return new Symbol(sym.ANDAND, 	yyline, yycolumn);}

.|\n    {}




